/* --------------------------------------------------------------
  Debug.js 2019-06-07
  Gambio GmbH
  http://www.gambio.de
  Copyright (c) 2019 Gambio GmbH
  Released under the GNU General Public License (Version 2)
  [http://www.gnu.org/licenses/gpl-2.0.html]
  --------------------------------------------------------------*/


'use strict';

/**
 * Log the message.
 *
 * @param {String} type Log type can either be 'log', 'info', 'warning' or 'error'.
 * @param {*} data The data to be logged.
 *
 * @private
 */
function _log(type, data) {
	if (StyleEdit.Config.get('environment') === 'production') {
		return;
	}
	
	if (console[type] !== undefined && typeof console[type].apply === 'function') {
		console[type].apply(console, data);
	} else {
		console.log(data);
	}
}

export default {
	/**
	 * Perform a debug log.
	 *
	 * Provide any arguments that need to be logged.
	 */
	log() {
		_log('log', arguments);
	},
	
	/**
	 * Perform a debug info.
	 *
	 * Provide any arguments that need to be logged.
	 */
	info() {
		_log('info', arguments);
	},
	
	/**
	 * Perform a debug warn.
	 *
	 * Provide any arguments that need to be logged.
	 */
	warn() {
		_log('warn', arguments);
	},
	
	/**
	 * Perform a debug error.
	 *
	 * Provide any arguments that need to be logged.
	 */
	error() {
		_log('error', arguments);
	},
	
	/**
	 * Perform a debug alert.
	 *
	 * @param {Object} data Contains the data to be alerted.
	 */
	alert(data) {
		if (StyleEdit.Config.get('environment') === 'production') {
			return;
		}
		
		window.alert('StyleEdit: ' + JSON.stringify(data));
	}
}
